from kyt import *
import subprocess
import asyncio
import math
import time
import random
import requests
import datetime as DT
import os
import re
from telethon.tl.custom import Button
from telethon import events
from telethon.errors import AlreadyInConversationError

# =================================================================
# FUNGSI PEMBANTU: AMBIL DATA & FORMAT PAGINATION
# =================================================================
def get_ssh_data():
    """Mengambil data raw dari script shell dengan Auto-Detect Path"""
    possible_paths = [
        '/usr/bin/kyt/shell/bot/bot-member-ssh',
        '/usr/bin/kyt/shell/bot-member-ssh',
        'bot-member-ssh'
    ]
    
    cmd = None
    for path in possible_paths:
        if os.path.exists(path):
            cmd = path
            break
            
    if not cmd: return []

    try:
        subprocess.run(f"chmod +x {cmd}", shell=True)
        raw_output = subprocess.check_output(cmd, shell=True, stderr=subprocess.STDOUT).decode("utf-8")
        data_list = [line for line in raw_output.splitlines() if line.strip()]
        return data_list
    except:
        return []

def render_page(data_list, page, item_per_page=10):
    total_items = len(data_list)
    total_pages = math.ceil(total_items / item_per_page)
    
    if page < 0: page = 0
    if total_pages > 0 and page >= total_pages: page = total_pages - 1
    if total_pages == 0: page = 0 
    
    start = page * item_per_page
    end = start + item_per_page
    sliced_data = data_list[start:end]
    
    msg = f"""
<b>☁️ LIST MEMBER SSH & VPN</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
"""
    if not sliced_data:
        msg += "<i>⚠️ Tidak ada user SSH aktif saat ini.</i>"
    else:
        for row in sliced_data:
            try:
                parts = row.split("|")
                if len(parts) >= 3:
                    user = parts[0]
                    exp = parts[1]
                    status = parts[2]
                    icon_stat = "🟢" if "UNLOCKED" in status else "🔴"
                    msg += f"""
<b>👤 User :</b> <code>{user}</code>
<b>📅 Exp  :</b> <code>{exp}</code>
<b>💎 Stat :</b> {icon_stat} <code>{status}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
"""
                else: continue
            except: continue

    display_page = page + 1 if total_pages > 0 else 0
    msg += f"\n📊 <b>Total:</b> {total_items} Users | 📄 <b>Page:</b> {display_page}/{total_pages}"
    return msg, total_pages

# =================================================================
# 1. CREATE SSH
# =================================================================
@bot.on(events.CallbackQuery(data=b'create-ssh'))
async def create_ssh(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Akses Ditolak", alert=True)
        return

    async def create_ssh_process():
        try:
            async with bot.conversation(chat, timeout=120) as user_convo:
                await event.respond('<b>👤 Input Username:</b>\n(Ketik <code>/cancel</code> untuk batal)', parse_mode='html')
                user_event = await user_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if user_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                user = user_event.raw_text
            
            async with bot.conversation(chat, timeout=120) as pw_convo:
                await event.respond("<b>🔑 Input Password:</b>", parse_mode='html')
                pw_event = await pw_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if pw_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                pw = pw_event.raw_text
    
            async with bot.conversation(chat, timeout=120) as limit_convo:
                await event.respond("<b>📱 Input Max Login/IP Limit:</b>\nContoh: <code>2</code>", parse_mode='html')
                limit_event = await limit_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if limit_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                limit = limit_event.raw_text

            async with bot.conversation(chat, timeout=120) as quota_convo:
                await event.respond("<b>💾 Input Quota (GB):</b>\nContoh: <code>10</code>", parse_mode='html')
                quota_event = await quota_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if quota_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                quota = quota_event.raw_text
            
            async with bot.conversation(chat, timeout=120) as exp_convo:
                await event.respond("<b>📅 Input Masa Aktif (Hari):</b>\nContoh: <code>30</code>", parse_mode='html')
                exp_event = await exp_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if exp_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                exp = exp_event.raw_text
        
            msg_load = await event.respond("<code>🔄 Processing SSH & ZiVPN Account...</code>", parse_mode='html')
            
            cmd_sys = f'useradd -e `date -d "{exp} days" +"%Y-%m-%d"` -s /bin/false -M {user} && echo "{user}:{pw}" | chpasswd && echo "{user} hard maxlogins {limit}" >> /etc/security/limits.conf'
            
            try:
                subprocess.check_output(cmd_sys, shell=True, stderr=subprocess.STDOUT)
                
                today = DT.date.today()
                later = today + DT.timedelta(days=int(exp))
                exp_date_str = later.strftime("%Y-%m-%d")
                
                cmd_zivpn = f"""
                jq --arg u "{user}" '.auth.config += [$u]' /etc/zivpn/config.json > /etc/zivpn/config.json.tmp && mv /etc/zivpn/config.json.tmp /etc/zivpn/config.json && \\
                jq --arg u "{user}" --arg e "{exp_date_str}" --arg i "{limit}" --arg q "{quota}" '.[$u] = {{exp: $e, ip: $i, quota: $q}}' /etc/zivpn/user-db.json > /etc/zivpn/user-db.json.tmp && mv /etc/zivpn/user-db.json.tmp /etc/zivpn/user-db.json && \\
                systemctl restart zivpn
                """
                subprocess.run(cmd_zivpn, shell=True)

            except subprocess.CalledProcessError:
                await msg_load.delete()
                await event.respond("<b>⚠️ User Already Exist / Error</b>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
            else:
                msg = f"""
<b>✅ SSH & ZIVPN ACCOUNT CREATED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 Username :</b> <code>{user.strip()}</code>
<b>🔑 Password :</b> <code>{pw.strip()}</code>
<b>⏳ Expired  :</b> <code>{later}</code>
<b>📱 Limit IP :</b> <code>{limit.strip()} Device</code>
<b>💾 Quota    :</b> <code>{quota.strip()} GB</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔌 CONNECTION DETAILS</b>
<b>🌐 Host/IP  :</b> <code>{DOMAIN}</code>
<b>🔮 SSH SSL  :</b> <code>{DOMAIN}:443</code>
<b>🔮 SSH WS   :</b> <code>{DOMAIN}:80</code>
<b>🧩 UDP Custom:</b> <code>{DOMAIN}:5667</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
                await msg_load.delete()
                await event.respond(msg, parse_mode='html', buttons=[[Button.inline("‹ Main Menu ›", "menu")]])

        except AlreadyInConversationError:
            await event.answer("⚠️ Sedang ada proses lain! Ketik /cancel dulu.", alert=True)
        except asyncio.TimeoutError:
            await event.respond("<b>❌ Waktu Habis.</b>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
        except Exception as e:
            await event.respond(f"<b>❌ Error:</b> <code>{str(e)}</code>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')

    await create_ssh_process()

# =================================================================
# 2. DELETE SSH
# =================================================================
@bot.on(events.CallbackQuery(data=b'delete-ssh'))
async def delete_ssh(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Akses Ditolak", alert=True)
        return

    async def delete_ssh_process():
        try:
            async with bot.conversation(chat, timeout=120) as user_convo:
                await event.respond("<b>🗑️ Username To Be Deleted:</b>\n(Ketik <code>/cancel</code> untuk batal)", parse_mode='html')
                user_event = await user_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if user_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                user = user_event.raw_text
                
            cmd = f'userdel -f {user}'
            try:
                subprocess.check_output(cmd, shell=True, stderr=subprocess.STDOUT)
            except subprocess.CalledProcessError:
                await event.respond(f"<b>❌ User</b> <code>{user}</code> <b>Not Found</b>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
            else:
                subprocess.run(f'sed -i "/^{user} hard maxlogins/d" /etc/security/limits.conf', shell=True)
                cmd_zivpn_del = f"""
                jq --arg u "{user}" '.auth.config -= [$u]' /etc/zivpn/config.json > /etc/zivpn/config.json.tmp && mv /etc/zivpn/config.json.tmp /etc/zivpn/config.json && \\
                jq --arg u "{user}" 'del(.[$u])' /etc/zivpn/user-db.json > /etc/zivpn/user-db.json.tmp && mv /etc/zivpn/user-db.json.tmp /etc/zivpn/user-db.json && \\
                systemctl restart zivpn
                """
                subprocess.run(cmd_zivpn_del, shell=True)
                await event.respond(f"<b>✅ Successfully Deleted:</b> <code>{user}</code>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
                
        except AlreadyInConversationError:
            await event.answer("⚠️ Sedang ada proses lain! Ketik /cancel dulu.", alert=True)
        except asyncio.TimeoutError:
            await event.respond("<b>❌ Timeout.</b>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
        except Exception as e:
            await event.respond(f"<b>❌ Error:</b> <code>{str(e)}</code>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
            
    await delete_ssh_process()

# =================================================================
# 3. TRIAL SSH
# =================================================================
@bot.on(events.CallbackQuery(data=b'trial-ssh'))
async def trial_ssh(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Akses Ditolak", alert=True)
        return

    async def trial_ssh_process():
        try:
            async with bot.conversation(chat, timeout=60) as exp_convo:
                await event.respond("<b>⏱️ Input Trial Time (Menit):</b>\nContoh: <code>60</code>\n(Ketik <code>/cancel</code> untuk batal)", parse_mode='html')
                exp_event = await exp_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                if exp_event.raw_text == '/cancel':
                    await event.respond("❌ <b>Proses Dibatalkan.</b>", parse_mode='html')
                    return
                exp = exp_event.raw_text
                if not exp.isdigit():
                     await event.respond("<b>❌ Error: Harap masukkan angka.</b>", parse_mode='html')
                     return

            user = "trialX"+str(random.randint(100,1000))
            pw = "1"
            limit = "1"
            quota = "1"
            
            msg_load = await event.respond("<code>🔄 Creating Trial SSH & ZiVPN...</code>", parse_mode='html')
            
            cmd_sys = f'useradd -e "`date -d "{exp} minutes" +"%Y-%m-%d %H:%M:%S"`" -s /bin/false -M {user} && echo "{user}:{pw}" | chpasswd && echo "{user} hard maxlogins 1" >> /etc/security/limits.conf'
            
            try:
                subprocess.check_output(cmd_sys, shell=True, stderr=subprocess.STDOUT)
                tomorrow = DT.date.today() + DT.timedelta(days=1)
                exp_date_str = tomorrow.strftime("%Y-%m-%d")
                cmd_zivpn = f"""
                jq --arg u "{user}" '.auth.config += [$u]' /etc/zivpn/config.json > /etc/zivpn/config.json.tmp && mv /etc/zivpn/config.json.tmp /etc/zivpn/config.json && \\
                jq --arg u "{user}" --arg e "{exp_date_str}" --arg i "{limit}" --arg q "{quota}" '.[$u] = {{exp: $e, ip: $i, quota: $q}}' /etc/zivpn/user-db.json > /etc/zivpn/user-db.json.tmp && mv /etc/zivpn/user-db.json.tmp /etc/zivpn/user-db.json && \\
                systemctl restart zivpn
                """
                subprocess.run(cmd_zivpn, shell=True)
            except subprocess.CalledProcessError:
                await msg_load.delete()
                await event.respond("<b>❌ Failed to create trial.</b>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
            else:
                msg = f"""
<b>✅ SSH & ZIVPN TRIAL CREATED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 Username :</b> <code>{user.strip()}</code>
<b>🔑 Password :</b> <code>{pw.strip()}</code>
<b>⏳ Expired  :</b> <code>{exp} Minutes</code>
<b>📱 Limit IP :</b> <code>1 Device</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔌 CONNECTION DETAILS</b>
<b>🌐 Host/IP  :</b> <code>{DOMAIN}</code>
<b>🔮 SSH SSL  :</b> <code>{DOMAIN}:443</code>
<b>🔮 SSH WS   :</b> <code>{DOMAIN}:80</code>
<b>🧩 UDP Custom:</b> <code>{DOMAIN}:5667</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
                await msg_load.delete()
                await event.respond(msg, parse_mode='html', buttons=[[Button.inline("‹ Main Menu ›", "menu")]])
        except Exception as e:
            await event.respond(f"<b>❌ Error:</b> <code>{str(e)}</code>", buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')
    await trial_ssh_process()

# =================================================================
# 4. SHOW SSH
# =================================================================
@bot.on(events.CallbackQuery(data=b'show-ssh'))
async def show_ssh(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Access Denied", alert=True)
        return

    data_list = get_ssh_data()
    msg, total_pages = render_page(data_list, 0)
    
    buttons = []
    if total_pages > 1:
        buttons.append([Button.inline("Next ⏩", data=f"sshPage_1")])
    buttons.append([Button.inline("‹ Main Menu ›", "menu")])
    try: await event.edit(msg, buttons=buttons, parse_mode='html')
    except: await event.reply(msg, buttons=buttons, parse_mode='html')

@bot.on(events.CallbackQuery(pattern=b'sshPage_(\d+)'))
async def paginate_ssh(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Access Denied", alert=True)
        return
    try: page = int(event.data.decode().split('_')[1])
    except: page = 0
    data_list = get_ssh_data()
    msg, total_pages = render_page(data_list, page)
    nav_buttons = []
    if page > 0: nav_buttons.append(Button.inline("⏪ Prev", data=f"sshPage_{page-1}"))
    if page < total_pages - 1: nav_buttons.append(Button.inline("Next ⏩", data=f"sshPage_{page+1}"))
    buttons = []
    if nav_buttons: buttons.append(nav_buttons)
    buttons.append([Button.inline("‹ Main Menu ›", "menu")])
    try: await event.edit(msg, buttons=buttons, parse_mode='html')
    except: await event.answer("Halaman tidak berubah")

# =================================================================
# 5. LOGIN SSH MONITOR (PREMIUM LOOK & LIVE SCAN)
# =================================================================
def parse_monitor_data(text):
    raw_blocks = text.split("┌──────────────────────────────────────────────────────┐")
    header_raw = raw_blocks[0]
    user_data = []
    for block in raw_blocks[1:]:
        try:
            user = re.search(r"User\s+:\s+(.*?)\s*│", block).group(1).strip()
            user = re.sub(r'\[[0-9;]*m', '', user) 
            pw = re.search(r"Pass\s+:\s+(.*?)\s*│", block).group(1).strip()
            exp = re.search(r"Expired\s+:\s+(.*?)\s*│", block).group(1).strip()
            exp = " ".join(exp.split()) 
            usage = re.search(r"Usage\s+:\s+(.*?)\s*│", block).group(1).strip()
            status = re.search(r"Status\s+:\s+(.*?)\s*│", block).group(1).strip()
            user_data.append({"user": user, "pw": pw, "exp": exp, "usage": usage, "status": status})
        except: pass
    return header_raw, user_data

def render_monitor_page(user_data, page, item_per_page=5):
    total_items = len(user_data)
    total_pages = math.ceil(total_items / item_per_page)
    if page < 0: page = 0
    if total_pages > 0 and page >= total_pages: page = total_pages - 1
    if total_pages == 0: page = 0 
    start = page * item_per_page
    end = start + item_per_page
    sliced_data = user_data[start:end]
    msg = f"<b>📊 LIVE TRAFFIC MONITOR</b>\n▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬"
    if not sliced_data:
        msg += "\n\n<i>⚠️ Tidak ada user online saat ini.</i>"
    else:
        for u in sliced_data:
            msg += f"""
👤 <b>{u['user']}</b>
├ 🔑 <code>{u['pw']}</code>
├ ⏳ {u['exp']}
├ 📊 {u['usage']}
└ {u['status']}
"""
    msg += f"\n▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬\n<b>👥 Online: {total_items} | 📄 Halaman: {page+1}/{total_pages}</b>"
    return msg, total_pages, page

async def run_login_monitor(event, page=0):
    cmd = '/usr/bin/kyt/shell/bot/bot-login-monitor'
    try: msg_wait = await event.edit("<b>🔄 Scanning Network...</b>\n<i>Mohon tunggu sebentar...</i>", parse_mode='html')
    except: msg_wait = await event.respond("<b>🔄 Scanning Network...</b>\n<i>Mohon tunggu sebentar...</i>", parse_mode='html')
    try:
        if not os.path.exists(cmd):
            await msg_wait.edit("❌ <b>Error:</b> Script monitor hilang.", parse_mode='html')
            return
        subprocess.run(f"chmod +x {cmd}", shell=True)
        subprocess.run(f"sed -i 's/\r$//' {cmd}", shell=True)
        process = subprocess.run(cmd, shell=True, check=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        raw_output = process.stdout.decode("utf-8", errors="ignore")
        ansi_escape = re.compile(r'\x1B(?:[@-Z\\-_]|\[[0-?]*[ -/]*[@-~])')
        clean_output = ansi_escape.sub('', raw_output)
        header_garbage, user_list = parse_monitor_data(clean_output)
        final_msg, total_pages, current_page = render_monitor_page(user_list, page, item_per_page=5)
        nav_buttons = []
        if current_page > 0: nav_buttons.append(Button.inline("⏪ Prev", data=f"loginPage_{current_page-1}"))
        if current_page < total_pages - 1: nav_buttons.append(Button.inline("Next ⏩", data=f"loginPage_{current_page+1}"))
        buttons = []
        if nav_buttons: buttons.append(nav_buttons)
        buttons.append([Button.inline("🔄 Refresh (Live)", data=f"loginPage_{current_page}"), Button.inline("‹ Main Menu ›", "menu")])
        await msg_wait.edit(final_msg, buttons=buttons, parse_mode='html')
    except Exception as e:
        await msg_wait.edit(f"<b>❌ Error:</b>\n<code>{str(e)}</code>", parse_mode='html')

@bot.on(events.CallbackQuery(data=b'login-ssh'))
async def login_ssh(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Access Denied", alert=True)
        return
    await run_login_monitor(event, page=0)

@bot.on(events.CallbackQuery(pattern=b'loginPage_(\d+)'))
async def paginate_login(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Access Denied", alert=True)
        return
    try: page = int(event.data.decode().split('_')[1])
    except: page = 0
    await run_login_monitor(event, page=page)

# =================================================================
# 6. REGIS IP INFO (NEW FEATURE)
# =================================================================
@bot.on(events.CallbackQuery(data=b'regis'))
async def regis_ip_check(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Akses Ditolak", alert=True)
        return
    
    # Pesan Loading
    msg_wait = await event.respond("<b>🔄 Checking IP License...</b>", parse_mode='html')

    try:
        # 1. Ambil IP VPS
        try:
            my_ip = subprocess.check_output("curl -sS ipv4.icanhazip.com", shell=True).decode("utf-8").strip()
        except:
            my_ip = "Unknown IP"

        # 2. Ambil Data dari GitHub
        url_izin = "https://raw.githubusercontent.com/hokagelegend9999/ijin/refs/heads/main/alpha"
        try:
            r = requests.get(url_izin)
            data = r.text
        except:
            await msg_wait.edit("❌ <b>Error:</b> Gagal menghubungi GitHub.", parse_mode='html')
            return

        # 3. Parsing Data
        username = "Unregistered"
        exp_date = "-"
        status = "🔴 Expired / Unregistered"
        validity = "0 Days"
        
        found = False
        
        # Loop setiap baris di data github
        for line in data.splitlines():
            if my_ip in line:
                parts = line.split()
                if len(parts) >= 3:
                    username = parts[1]
                    exp_date = parts[2]
                    found = True
                    break
        
        # 4. Hitung Masa Aktif
        if found:
            try:
                today = DT.date.today()
                exp_dt = DT.datetime.strptime(exp_date, "%Y-%m-%d").date()
                diff = (exp_dt - today).days
                
                validity = f"{diff} Days"
                
                if diff >= 0:
                    status = "🟢 Active"
                else:
                    status = "🔴 Expired"
                    validity = "Expired"
            except:
                validity = "Error Date"
        
        # 5. Tampilkan Hasil
        msg = f"""
<b>📂 USER LICENSE STATUS</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🖥️ IP VPS     :</b> <code>{my_ip}</code>
<b>👤 Username   :</b> <code>{username}</code>
<b>📅 Expired    :</b> <code>{exp_date}</code>
<b>⏳ Validity   :</b> <code>{validity}</code>
<b>💎 Status     :</b> {status}
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
        await msg_wait.edit(msg, buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')

    except Exception as e:
        await msg_wait.edit(f"<b>❌ System Error:</b>\n<code>{str(e)}</code>", parse_mode='html')

# =================================================================
# 6. MENU UTAMA SSH
# =================================================================
@bot.on(events.CallbackQuery(data=b'ssh'))
async def ssh(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Access Denied", alert=True)
        return
        
    try:
        # TOMBOL REGIS SUDAH DIHAPUS DARI SINI
        inline = [
            [Button.inline("☁️ TRIAL SSH ","trial-ssh"), Button.inline("⚡ CREATE SSH ","create-ssh")],
            [Button.inline("🗑️ DELETE SSH ","delete-ssh"), Button.inline("🔐 CHECK LOGIN","login-ssh")],
            [Button.inline("📊 LIST USER SSH ","show-ssh")],
            [Button.inline("‹ Main Menu ›","menu")]
        ]
        try:
             isp = subprocess.check_output("curl --max-time 2 -s http://ip-api.com/json | python3 -c \"import sys, json; print(json.load(sys.stdin).get('isp', 'Unknown'))\"", shell=True).decode("utf-8").strip()
             country = subprocess.check_output("curl --max-time 2 -s http://ip-api.com/json | python3 -c \"import sys, json; print(json.load(sys.stdin).get('country', 'Unknown'))\"", shell=True).decode("utf-8").strip()
        except:
             isp = "Unknown"
             country = "Unknown"

        msg = f"""
<b>☁️ SSH & OVPN MANAGER</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🟢 Service Status :</b> <code>Active</code>
<b>🌐 Hostname/IP    :</b> <code>{DOMAIN}</code>
<b>📡 ISP Provider   :</b> <code>{isp}</code>
<b>🌍 Region/City    :</b> <code>{country}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
        await event.edit(msg, buttons=inline, parse_mode='html')
    except Exception as e:
        await event.respond(f"Error: {str(e)}")