from kyt import *
import requests
import time
import subprocess
import speedtest as st
from datetime import date
from telethon import events
from telethon.tl.custom import Button

# --- REBOOT SERVER ---
@bot.on(events.CallbackQuery(data=b'reboot'))
async def reboot(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Rebooting...", alert=False)
    msg = await event.edit("`Initiating Reboot Sequence...`")
    
    animasi = [
        "Processing... 10% ▒▒▒▒▒▒▒▒▒▒", "Processing... 30% ███▒▒▒▒▒▒▒",
        "Processing... 60% ██████▒▒▒▒", "Processing... 90% █████████▒",
        "Processing... 100% ██████████"
    ]
    for anim in animasi:
        await msg.edit(f"`{anim}`")
        time.sleep(0.5)

    try:
        subprocess.Popen("reboot", shell=True)
        await msg.edit(f"""
<b>✅ SERVER REBOOTED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Server berhasil direstart.</i>
<i>Tunggu 1-2 menit hingga bot kembali online.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", parse_mode='html')
    except Exception as e:
        await msg.edit(f"❌ <b>Error:</b> {str(e)}", parse_mode='html')

# --- RESTART SERVICE ---
@bot.on(events.CallbackQuery(data=b'resx'))
async def restart_service(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Restarting Services...", alert=False)
    msg = await event.edit("`Starting Service Manager...`")
    
    try:
        subprocess.check_output("resservice", shell=True)
        animasi = [
            "🔄 Restarting Xray Core...", "🔄 Restarting Nginx Server...",
            "🔄 Restarting Dropbear & SSH...", "✅ All Services Restarted!"
        ]
        for anim in animasi:
            await msg.edit(f"`{anim}`")
            time.sleep(0.8)

        await msg.edit(f"""
<b>✅ SERVICE RESTARTED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Semua layanan VPN telah di-refresh.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], parse_mode='html')
    except Exception as e:
        await msg.edit(f"❌ <b>Error:</b> {str(e)}", parse_mode='html')

# --- SPEEDTEST (PYTHON LIBRARY) ---
@bot.on(events.CallbackQuery(data=b'speedtest'))
async def speedtest_handler(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Running Speedtest...", alert=False)
    msg = await event.edit("`Initializing Speedtest Engine...`")
    
    frames = [
        "🟡 <b>Finding Best Server...</b>\n▒▒▒▒▒▒▒▒▒▒ 0%",
        "🔵 <b>Testing Download Speed...</b>\n████▒▒▒▒▒▒ 40%",
        "🟢 <b>Testing Upload Speed...</b>\n████████▒▒ 80%",
        "🟣 <b>Finalizing Data...</b>\n██████████ 100%"
    ]
    for frame in frames:
        await msg.edit(frame, parse_mode='html')
        time.sleep(0.5)
    
    try:
        s = st.Speedtest()
        s.get_best_server()
        s.download()
        s.upload()
        
        try:
            link = s.results.share()
        except:
            link = None

        res = s.results.dict()
        ping = f"{res['ping']} ms"
        dl = f"{res['download'] / 10**6:.2f} Mbps"
        ul = f"{res['upload'] / 10**6:.2f} Mbps"
        isp = res['client']['isp']
        server = f"{res['server']['sponsor']} ({res['server']['name']})"

        caption_msg = f"""
<b>🚀 SPEEDTEST RESULT</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
┌───────────────────────
│ 📶 <b>PING</b>      : <code>{ping}</code>
│ ⬇️ <b>DOWNLOAD</b>  : <code>{dl}</code>
│ ⬆️ <b>UPLOAD</b>    : <code>{ul}</code>
└───────────────────────
<b>🏢 ISP    :</b> <code>{isp}</code>
<b>📍 Server :</b> <code>{server}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
"""
        await msg.delete()

        if link:
            await bot.send_file(
                event.chat_id,
                file=link,
                caption=caption_msg,
                buttons=[[Button.inline("‹ Back to Menu ›", "setting")]],
                parse_mode='html'
            )
        else:
            await event.respond(
                caption_msg,
                buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], 
                parse_mode='html'
            )

    except Exception as e:
        await msg.edit(f"""
<b>❌ SPEEDTEST FAILED</b>
<pre>{str(e)}</pre>
""", buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], parse_mode='html')

# --- MENU BACKUP & RESTORE ---
@bot.on(events.CallbackQuery(data=b'backer'))
async def backup_restore_menu(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    try:
        z = requests.get(f"http://ip-api.com/json/?fields=country,isp", timeout=2).json()
        isp = z.get("isp", "Unknown")
        country = z.get("country", "Unknown")
    except:
        isp = "Unknown"
        country = "Unknown"

    msg = f"""
<b>💾 BACKUP & RESTORE</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🖥 SERVER INFO</b>
┌────────────────────────
│ <b>📡 IP/Host :</b> <code>{DOMAIN}</code>
│ <b>🏢 ISP     :</b> <code>{isp}</code>
│ <b>🌍 Country :</b> <code>{country}</code>
└────────────────────────
<i>Silakan pilih opsi di bawah:</i>
"""
    inline = [
        [Button.inline("📥 BACKUP DATA", "backup"), Button.inline("📤 RESTORE DATA", "restore")],
        [Button.inline("‹ Back to Setting ›", "setting")]
    ]
    await event.edit(msg, buttons=inline, parse_mode='html')

# --- PROSES BACKUP (UPDATED PARSING & ANIMATION) ---
@bot.on(events.CallbackQuery(data=b'backup'))
async def process_backup(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    async with bot.conversation(chat) as conv:
        await event.respond('<b>📩 Masukkan Email Tujuan Backup:</b>', parse_mode='html')
        try:
            response = await conv.wait_event(events.NewMessage(incoming=True, from_users=sender.id), timeout=60)
            email = response.raw_text.strip()
        except:
            return await event.respond("❌ <b>Waktu Habis.</b> Silakan ulangi.", parse_mode='html')

    # Initial Loading Message
    msg = await event.respond("⏳ <b>Initializing Backup...</b>", parse_mode='html')
    
    # 1. ANIMASI PROSES BACKUP
    frames = [
        "♻️ <b>Gathering Server Data...</b>\n▒▒▒▒▒▒▒▒▒▒ 10%",
        "📦 <b>Compressing System Files...</b>\n████▒▒▒▒▒▒ 40%",
        "☁️ <b>Connecting to Google Drive...</b>\n██████▒▒▒▒ 70%",
        "📨 <b>Sending Email Notification...</b>\n██████████ 99%"
    ]
    
    for frame in frames:
        await msg.edit(frame, parse_mode='html')
        time.sleep(1) # Jeda animasi biar terasa prosesnya

    # Pesan Final sebelum proses berat (Upload)
    await msg.edit("🚀 <b>Uploading to Google Drive...</b>\n<i>Mohon tunggu, proses ini tergantung kecepatan server...</i>", parse_mode='html')
    
    try:
        # Jalankan Script Backup
        cmd = f'/usr/bin/kyt/shell/bot/bot-backup "{email}"'
        process = subprocess.check_output(cmd, shell=True, stderr=subprocess.STDOUT)
        output_str = process.decode("utf-8")
        
        # --- IMPROVED LINK PARSING ---
        # Mencari link dengan lebih agresif
        link = "Link Not Found"
        for line in output_str.splitlines():
            # Cari baris yang mengandung 'drive.google.com'
            if "drive.google.com" in line:
                # Bersihkan text di sekitar link (misal: "Link: https://..." -> "https://...")
                parts = line.split()
                for part in parts:
                    if "http" in part:
                        link = part.strip()
                        break
        
        # Fallback jika masih not found tapi ada di baris "Link:"
        if link == "Link Not Found":
             for line in output_str.splitlines():
                if "Link:" in line: 
                    link = line.replace("Link:", "").strip()

        # Hasil Akhir
        await msg.edit(f"""
<b>✅ BACKUP SUKSES</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>📅 Date :</b> <code>{date.today()}</code>
<b>📧 Email:</b> <code>{email}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
🔗 <b>Google Drive Link:</b>
<a href="{link}">KLIK UNTUK DOWNLOAD</a>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", parse_mode='html', link_preview=False)

    except Exception as e:
        await msg.edit(f"❌ <b>Backup Error:</b>\n<pre>{str(e)}</pre>", parse_mode='html')

# --- PROSES RESTORE (DENGAN ANIMASI) ---
@bot.on(events.CallbackQuery(data=b'restore'))
async def process_restore(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    async with bot.conversation(chat) as conv:
        await event.respond('<b>📥 Masukkan Link Backup (Google Drive):</b>', parse_mode='html')
        try:
            response = await conv.wait_event(events.NewMessage(incoming=True, from_users=sender.id), timeout=60)
            link = response.raw_text.strip()
        except:
            return await event.respond("❌ <b>Waktu Habis.</b> Silakan ulangi.", parse_mode='html')

    msg = await event.respond("⏳ <b>Initializing Restore...</b>", parse_mode='html')

    # ANIMASI RESTORE
    frames = [
        "🔍 <b>Checking Backup URL...</b>\n▒▒▒▒▒▒▒▒▒▒ 10%",
        "⬇️ <b>Downloading Backup File...</b>\n████▒▒▒▒▒▒ 40%",
        "📦 <b>Extracting System Data...</b>\n██████▒▒▒▒ 70%",
        "♻️ <b>Restoring Database...</b>\n██████████ 99%"
    ]
    
    for frame in frames:
        await msg.edit(frame, parse_mode='html')
        time.sleep(1)

    await msg.edit("⚙️ <b>Applying Configurations...</b>\n<i>Mohon tunggu sebentar...</i>", parse_mode='html')

    try:
        cmd = f'/usr/bin/kyt/shell/bot/bot-restore "{link}"'
        subprocess.check_output(cmd, shell=True, stderr=subprocess.STDOUT)
        
        await msg.edit(f"""
<b>✅ RESTORE FINISHED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Data VPS telah berhasil dipulihkan.</i>
<i>Silakan cek fungsi server.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", parse_mode='html')

    except Exception as e:
        await msg.edit(f"❌ <b>Restore Failed:</b>\n<pre>{str(e)}</pre>", parse_mode='html')

# --- MENU SETTING UTAMA ---
@bot.on(events.CallbackQuery(data=b'setting'))
async def settings(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    try:
        z = requests.get(f"http://ip-api.com/json/?fields=country,isp", timeout=2).json()
        isp = z.get("isp", "Unknown")
        country = z.get("country", "Unknown")
    except:
        isp = "Unknown"
        country = "Unknown"

    msg = f"""
<b>⚙️ SETTING & MANAGER</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>💻 CONNECTION INFO</b>
┌────────────────────────
│ <b>📡 Host :</b> <code>{DOMAIN}</code>
│ <b>🏢 ISP  :</b> <code>{isp}</code>
│ <b>🌍 Loc  :</b> <code>{country}</code>
└────────────────────────
"""
    inline = [
        [Button.inline("🚀 SPEEDTEST", "speedtest"), Button.inline("💾 BACKUP & RESTORE", "backer")],
        [Button.inline("🔄 REBOOT SERVER", "reboot"), Button.inline("♻️ RESTART SERVICE", "resx")],
        [Button.inline("‹ Back to Dashboard ›", "menu")]
    ]
    
    await event.edit(msg, buttons=inline, parse_mode='html')