from kyt import *
import requests
import time
import subprocess
import speedtest as st
import os
import glob
import asyncio
import datetime
import re
from telethon import events
from telethon.tl.custom import Button

# =================================================================
# 1. REBOOT SERVER
# =================================================================
@bot.on(events.CallbackQuery(data=b'reboot'))
async def reboot(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Rebooting...", alert=False)
    msg = await event.edit("`Initiating Reboot Sequence...`")
    
    animasi = [
        "Processing... 10% ▒▒▒▒▒▒▒▒▒▒", "Processing... 30% ███▒▒▒▒▒▒▒",
        "Processing... 60% ██████▒▒▒▒", "Processing... 90% █████████▒",
        "Processing... 100% ██████████"
    ]
    for anim in animasi:
        await msg.edit(f"`{anim}`")
        time.sleep(0.5)

    try:
        subprocess.Popen("reboot", shell=True)
        await msg.edit(f"""
<b>✅ SERVER REBOOTED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Server berhasil direstart.</i>
<i>Tunggu 1-2 menit hingga bot kembali online.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", parse_mode='html')
    except Exception as e:
        await msg.edit(f"❌ <b>Error:</b> {str(e)}", parse_mode='html')

# =================================================================
# 2. RESTART SERVICE
# =================================================================
@bot.on(events.CallbackQuery(data=b'resx'))
async def restart_service(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Restarting Services...", alert=False)
    msg = await event.edit("`Starting Service Manager...`")
    
    try:
        subprocess.check_output("resservice", shell=True)
        animasi = [
            "🔄 Restarting Xray Core...", "🔄 Restarting Nginx Server...",
            "🔄 Restarting Dropbear & SSH...", "✅ All Services Restarted!"
        ]
        for anim in animasi:
            await msg.edit(f"`{anim}`")
            time.sleep(0.8)

        await msg.edit(f"""
<b>✅ SERVICE RESTARTED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Semua layanan VPN telah di-refresh.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], parse_mode='html')
    except Exception as e:
        await msg.edit(f"❌ <b>Error:</b> {str(e)}", parse_mode='html')

# =================================================================
# 3. SPEEDTEST
# =================================================================
@bot.on(events.CallbackQuery(data=b'speedtest'))
async def speedtest_handler(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    await event.answer("Running Speedtest...", alert=False)
    msg = await event.edit("`Initializing Speedtest Engine...`")
    
    frames = [
        "🟡 <b>Finding Best Server...</b>\n▒▒▒▒▒▒▒▒▒▒ 0%",
        "🔵 <b>Testing Download Speed...</b>\n████▒▒▒▒▒▒ 40%",
        "🟢 <b>Testing Upload Speed...</b>\n████████▒▒ 80%",
        "🟣 <b>Finalizing Data...</b>\n██████████ 100%"
    ]
    for frame in frames:
        await msg.edit(frame, parse_mode='html')
        time.sleep(0.5)
    
    try:
        s = st.Speedtest()
        s.get_best_server()
        s.download()
        s.upload()
        
        try:
            link = s.results.share()
        except:
            link = None

        res = s.results.dict()
        ping = f"{res['ping']} ms"
        dl = f"{res['download'] / 10**6:.2f} Mbps"
        ul = f"{res['upload'] / 10**6:.2f} Mbps"
        isp = res['client']['isp']
        server = f"{res['server']['sponsor']} ({res['server']['name']})"

        caption_msg = f"""
<b>🚀 SPEEDTEST RESULT</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
┌───────────────────────
│ 📶 <b>PING</b>     : <code>{ping}</code>
│ ⬇️ <b>DOWNLOAD</b> : <code>{dl}</code>
│ ⬆️ <b>UPLOAD</b>   : <code>{ul}</code>
└───────────────────────
<b>🏢 ISP    :</b> <code>{isp}</code>
<b>📍 Server :</b> <code>{server}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
"""
        await msg.delete()

        if link:
            await bot.send_file(
                event.chat_id,
                file=link,
                caption=caption_msg,
                buttons=[[Button.inline("‹ Back to Menu ›", "setting")]],
                parse_mode='html'
            )
        else:
            await event.respond(
                caption_msg,
                buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], 
                parse_mode='html'
            )

    except Exception as e:
        await msg.edit(f"""
<b>❌ SPEEDTEST FAILED</b>
<pre>{str(e)}</pre>
""", buttons=[[Button.inline("‹ Back to Menu ›", "setting")]], parse_mode='html')

# =================================================================
# 4. MENU BACKUP & RESTORE
# =================================================================
@bot.on(events.CallbackQuery(data=b'backer'))
async def backup_restore_menu(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    try:
        z = requests.get(f"http://ip-api.com/json/?fields=country,isp", timeout=2).json()
        isp = z.get("isp", "Unknown")
        country = z.get("country", "Unknown")
    except:
        isp = "Unknown"
        country = "Unknown"

    msg = f"""
<b>💾 BACKUP & RESTORE MANAGER</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🖥 SERVER INFO</b>
┌────────────────────────
│ <b>📡 IP/Host :</b> <code>{DOMAIN}</code>
│ <b>🏢 ISP      :</b> <code>{isp}</code>
│ <b>🌍 Country :</b> <code>{country}</code>
└────────────────────────
<i>Bot akan membuat file ZIP backup secara otomatis.</i>
"""
    inline = [
        [Button.inline("📥 CREATE BACKUP", "backup"), Button.inline("📤 RESTORE DATA", "restore")],
        [Button.inline("‹ Back to Setting ›", "setting")]
    ]
    await event.edit(msg, buttons=inline, parse_mode='html')

# =================================================================
# 5. PROSES BACKUP (AUTO-ZIP + GDRIVE LINK + ANIMATION)
# =================================================================
@bot.on(events.CallbackQuery(data=b'backup'))
async def process_backup(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    # 1. Minta Email
    async with bot.conversation(chat) as conv:
        await event.respond('<b>📩 Masukkan Email (Untuk Catatan):</b>', parse_mode='html')
        try:
            response = await conv.wait_event(events.NewMessage(incoming=True, from_users=sender.id), timeout=60)
            email = response.raw_text.strip()
        except:
            return await event.respond("❌ <b>Waktu Habis.</b> Silakan ulangi.", parse_mode='html')

    # 2. Loading Initialization
    msg = await event.respond("⏳ <b>Initializing Backup Engine...</b>", parse_mode='html')
    
    # Auto-Install ZIP
    if not os.path.exists("/usr/bin/zip"):
         await msg.edit("⚙️ <b>Installing ZIP package...</b>")
         subprocess.run("apt-get install zip -y", shell=True)

    # 3. Definisi Target Backup
    try:
        ip_vps = subprocess.check_output("curl -sS ipv4.icanhazip.com", shell=True).decode("utf-8").strip()
    except:
        ip_vps = "Unknown_IP"
        
    tgl = datetime.date.today().strftime("%Y-%m-%d")
    ts = datetime.datetime.now().strftime("%H-%M-%S")
    timestamp_file = datetime.datetime.now().strftime("%Y%m%d_%H%M%S")
    
    # Format nama file sesuai script bash
    zip_name = f"backup_{ip_vps}_{timestamp_file}.zip"
    zip_path = f"/root/{zip_name}"

    targets = [
        "/etc/passwd", "/etc/group", "/etc/shadow", "/etc/gshadow",
        "/etc/crontab", "/etc/xray", "/var/lib/kyt", "/var/www/html"
    ]
    
    valid_targets = [t for t in targets if os.path.exists(t)]
    target_str = " ".join(valid_targets)

    # 4. FUNGSI ANIMASI PROGRESS BAR
    async def run_progress_bar(msg, task_name, process):
        frames = [
            "[■□□□□□□□□□] 10%", "[■■□□□□□□□□] 20%", "[■■■□□□□□□□] 30%",
            "[■■■■□□□□□□] 40%", "[■■■■■□□□□□] 50%", "[■■■■■■□□□□] 60%",
            "[■■■■■■■□□□] 70%", "[■■■■■■■■□□] 80%", "[■■■■■■■■■□] 90%",
            "[■■■■■■■■■■] 100%"
        ]
        i = 0
        while process.returncode is None:
            await msg.edit(f"<b>{task_name}</b>\n{frames[i % len(frames)]}\n<i>Please wait...</i>", parse_mode='html')
            i += 1
            await asyncio.sleep(0.5)

    # 5. JALANKAN PROSES ZIP
    cmd_zip = f"zip -r {zip_path} {target_str}"
    proc_zip = await asyncio.create_subprocess_shell(
        cmd_zip, stdout=asyncio.subprocess.PIPE, stderr=asyncio.subprocess.PIPE
    )
    await run_progress_bar(msg, "📦 Compressing Files...", proc_zip)
    await proc_zip.wait()

    if not os.path.exists(zip_path):
        return await msg.edit("❌ <b>Gagal membuat file ZIP.</b>", parse_mode='html')

    # 6. JALANKAN UPLOAD GOOGLE DRIVE (RCLONE)
    link = "Rclone Not Configured / Error"
    
    # Cek config rclone
    check_rclone = subprocess.getoutput("rclone listremotes")
    
    if "dr:" in check_rclone:
        # A. UPLOAD
        cmd_up = f"rclone copy {zip_path} dr:backup/"
        proc_up = await asyncio.create_subprocess_shell(
            cmd_up, stdout=asyncio.subprocess.PIPE, stderr=asyncio.subprocess.PIPE
        )
        await run_progress_bar(msg, "🚀 Uploading to Google Drive...", proc_up)
        await proc_up.wait()
        
        # B. GENERATE LINK (Logika Script Bash)
        await msg.edit("🔗 <b>Generating Download Link...</b>", parse_mode='html')
        try:
            # Ambil link asli rclone
            cmd_link = f"rclone link dr:backup/{zip_name}"
            raw_link = subprocess.check_output(cmd_link, shell=True).decode("utf-8").strip()
            
            # Convert ke Direct Link (seperti di bash script Anda)
            if "id=" in raw_link:
                # Regex untuk ambil ID
                file_id = re.search(r'id=([a-zA-Z0-9_-]+)', raw_link)
                if file_id:
                    the_id = file_id.group(1)
                    # Format link direct download
                    link = f"https://drive.google.com/u/4/uc?id={the_id}&export=download"
                else:
                    link = raw_link # Fallback ke link asli jika regex gagal
            else:
                link = raw_link
        except:
            link = "Gagal generate link (Cek config rclone)"
    else:
        await msg.edit("⚠️ <b>Skipping Google Drive...</b>\n<i>Remote 'dr:' tidak ditemukan.</i>", parse_mode='html')
        await asyncio.sleep(2)

    await msg.delete()

    # 7. KIRIM HASIL & FILE ZIP
    caption_text = f"""
<b>✅ BACKUP SUKSES</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>📅 Date  :</b> <code>{tgl}</code>
<b>📧 Email :</b> <code>{email}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
🔗 <b>Google Drive Link:</b>
<a href="{link}">KLIK UNTUK DOWNLOAD</a>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>File ZIP telah dikirim ke chat ini.</i>
<b>🌋 HOKAGE LEGEND STORE</b>
"""

    try:
        await event.client.send_file(
            chat,
            zip_path,
            caption=caption_text,
            buttons=[[Button.inline("‹ Back to Setting ›", "backer")]],
            parse_mode='html',
            link_preview=False
        )
        # Hapus file lokal (Opsional)
        # os.remove(zip_path) 
    except Exception as e:
        await event.respond(
            f"❌ <b>Gagal Mengirim File ZIP:</b>\n<pre>{str(e)}</pre>\n\nFile tersimpan di VPS: <code>{zip_path}</code>",
            buttons=[[Button.inline("‹ Back to Setting ›", "backer")]],
            parse_mode='html'
        )

# =================================================================
# 6. PROSES RESTORE
# =================================================================
@bot.on(events.CallbackQuery(data=b'restore'))
async def process_restore(event):
    chat = event.chat_id
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    async with bot.conversation(chat) as conv:
        await event.respond('<b>📥 Masukkan Link Backup (Google Drive/Direct Link):</b>', parse_mode='html')
        try:
            response = await conv.wait_event(events.NewMessage(incoming=True, from_users=sender.id), timeout=60)
            link = response.raw_text.strip()
        except:
            return await event.respond("❌ <b>Waktu Habis.</b> Silakan ulangi.", parse_mode='html')

    msg = await event.respond("⏳ <b>Initializing Restore...</b>", parse_mode='html')

    frames = [
        "🔍 <b>Checking Backup URL...</b>\n▒▒▒▒▒▒▒▒▒▒ 10%",
        "⬇️ <b>Downloading Backup File...</b>\n████▒▒▒▒▒▒ 40%",
        "📦 <b>Extracting System Data...</b>\n██████▒▒▒▒ 70%",
        "♻️ <b>Restoring Database...</b>\n██████████ 99%"
    ]
    
    for frame in frames:
        await msg.edit(frame, parse_mode='html')
        time.sleep(1)

    await msg.edit("⚙️ <b>Applying Configurations...</b>\n<i>Mohon tunggu sebentar...</i>", parse_mode='html')

    try:
        cmd = f'/usr/bin/kyt/shell/bot/bot-restore "{link}"'
        
        # Manual Unzip jika script restore tidak ada
        if not os.path.exists("/usr/bin/kyt/shell/bot/bot-restore"):
             subprocess.run(f"wget -O /root/backup_restore.zip '{link}'", shell=True)
             subprocess.run(f"unzip -o /root/backup_restore.zip -d /", shell=True)
             subprocess.run("rm -f /root/backup_restore.zip", shell=True)
        else:
             subprocess.check_output(cmd, shell=True, stderr=subprocess.STDOUT)
        
        await msg.edit(f"""
<b>✅ RESTORE FINISHED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Data VPS telah berhasil dipulihkan.</i>
<i>Silakan cek fungsi server.</i>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌋 HOKAGE LEGEND STORE</b>
""", buttons=[[Button.inline("‹ Back to Setting ›", "backer")]], parse_mode='html')

    except Exception as e:
        await msg.edit(f"❌ <b>Restore Failed:</b>\n<pre>{str(e)}</pre>", buttons=[[Button.inline("‹ Back to Setting ›", "backer")]], parse_mode='html')

# =================================================================
# 7. MENU SETTING UTAMA
# =================================================================
@bot.on(events.CallbackQuery(data=b'setting'))
async def settings(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        return await event.answer("❌ Access Denied", alert=True)

    try:
        z = requests.get(f"http://ip-api.com/json/?fields=country,isp", timeout=2).json()
        isp = z.get("isp", "Unknown")
        country = z.get("country", "Unknown")
    except:
        isp = "Unknown"
        country = "Unknown"

    msg = f"""
<b>⚙️ SETTING & MANAGER</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>💻 CONNECTION INFO</b>
┌────────────────────────
│ <b>📡 Host :</b> <code>{DOMAIN}</code>
│ <b>🏢 ISP  :</b> <code>{isp}</code>
│ <b>🌍 Loc  :</b> <code>{country}</code>
└────────────────────────
"""
    inline = [
        [Button.inline("🚀 SPEEDTEST", "speedtest"), Button.inline("💾 BACKUP & RESTORE", "backer")],
        [Button.inline("🔄 REBOOT SERVER", "reboot"), Button.inline("♻️ RESTART SERVICE", "resx")],
        [Button.inline("‹ Back to Dashboard ›", "menu")]
    ]
    
    await event.edit(msg, buttons=inline, parse_mode='html')